/**
 ******************************************************************************
 **	FILE NAME  : balancer.c
 **
 **	ABSTRUCT   : Two wheeled self-balancing robot "NXTway-GS" balance control program.
 **              NXTway-GS balance control algorithum is based on modern control theory
 **              which is servo control (state + integral feedback).
 **              To develop the controller and indentify the plant, The MathWorks
 **              MATLAB&Simulink had been used and this design methodology is
 **              called MBD (Model-Based Design/Development). This C source code
 **              is automatically generated from a Simulink model by using standard features
 **              of Real-Time Workshop Embedded Coder. All control parameters need to be defined
 **              by user and the sample parameters are defined in nxtOSEK\samples\nxtway_gs\balancer_param.c.
 **              For more detailed information about the controller alogorithum, please check:
 **               English : http://www.mathworks.com/matlabcentral/fileexchange/loadFile.do?objectId=19147&objectType=file
 **               Japanese: http://www.cybernet.co.jp/matlab/library/library/detail.php?id=TA060
 **
 ** MODEL INFO:
 **   MODEL NAME : balancer.mdl
 **   VERSION    : 1.893
 **   HISTORY    : y_yama - Tue Sep 25 11:37:09 2007
 **                takashic - Sun Sep 28 17:50:53 2008
 **
 ** Copyright (c) 2011 MathWorks, Inc.
 ** All rights reserved.
 ******************************************************************************
 **/
/**
 ******************************************************************************
 **	t@C : balancer.c
 **
 **	Tv       : 2֌^|Uq{bguNXTway-GSvoXvO
 **              NXTway-GS̃oXɂ́AT[{( + ϕtB[hobN)
 **              Ƃ㐧KpĂ܂BΏۂ̓肨ѐ̊J
 **              ɂThe MathWorksЂMATLAB&SimulinkƂigpA
 **              MBD(fx[XfUC/J)J@pĂ܂BCvO
 **              SimulinkfReal-Time Workshop Embedded CoderR[hW@\
 **              gpĎꂽ̂łBoX̐p[^ɂĂ
 **              [U[nhR[hŒ`Kv܂B`ƂāA
 **              nxtOSEK\samples\nxtway_gs\balancer_param.cQƂĂB
 **              oXASY̏ڍ׏ɂ܂Ă
 **                {: http://www.cybernet.co.jp/matlab/library/library/detail.php?id=TA060
 **                p  : http://www.mathworks.com/matlabcentral/fileexchange/loadFile.do?objectId=19147&objectType=file
 **              QƂĂB
 **
 ** f֘A:
 **   f   : balancer.mdl
 **   o[W : 1.893
 **          :  -
 **                 -
 **
 ** Copyright (c) 2009-2011 MathWorks, Inc.
 ** All rights reserved.
 ******************************************************************************
 **/
#include "balancer.h"
#include "balancer_private.h"

/*============================================================================
 * Local macro definitions
 *===========================================================================*/

/*============================================================================
 * Data definitions
 *===========================================================================*/
static F32 ud_err_theta;          /* Eԗւ̕ω]px()ڕW덷Ԓl */
static F32 ud_psi;                /* ԑ̃sb`px()Ԓl */
static F32 ud_theta_lpf;          /* Eԗւ̕ω]px()Ԓl */
static F32 ud_theta_ref;          /* Eԗւ̖ڕWω]px()Ԓl */
static F32 ud_thetadot_cmd_lpf;   /* Eԗւ̖ڕWω]px(d/dt)Ԓl */

/*============================================================================
 * Functions
 *===========================================================================*/
//*****************************************************************************
// FUNCTION    : balance_control
// PARAMETERS  :
//   (F32)args_cmd_forward : forward/backward command. 100(max. forward) to -100(max. backward)
//   (F32)args_cmd_turn    : turn command. 100(right max.turn) to -100(left max. turn)
//   (F32)args_gyro        : gyro sensor data
//   (F32)args_gyro_offset : gyro sensor offset data
//   (F32)args_theta_m_l   : left wheel motor count
//   (F32)args_theta_m_r   : right wheel motor count
//   (F32)args_battery     : battery voltage(mV)
// RETURN      :
//   (S8*)ret_pwm_l        : left motor PWM output
//   (S8*)ret_pwm_r        : right motor PWM output
// DESCRIPTION : NXTway-GS balance control function
//               This function must be invoked in 4msec period.
//               Gyro sensor offset data is varied depending on a product and it has drift
//               while it's turned on, so these things need to be considered.
//               Left & right motor revolutions may be different even if a same PWM output is
//               given, in this case, user needs to add some motor revolution compensator.
// SAMPLE CODE :
//        /* go straight forward with maximum speed */
//        balance_control(
//          (F32)100,                                  /* max. forward command    */
//          (F32)0,                                    /* no turn command         */
//          (F32)ecrobot_get_gyro_sensor(NXT_PORT_S4), /* gyro sensor data        */
//          (F32)605,                                  /* gyro sensor offset data */
//          (F32)nxt_motor_get_count(NXT_PORT_C),      /* left wheel motor count  */
//          (F32)nxt_motor_get_count(NXT_PORT_B),      /* right wheel motor count */
//          (F32)ecrobot_get_battery_voltage(),        /* battery voltage(mV)     */
//          &pwm_l,                                    /* left motor PWM output   */
//          &pwm_r);                                   /* right motor PWM output  */
//*****************************************************************************
//*****************************************************************************
// FUNCTION    : balance_init
// PARAMETERS  : none
// RETURN      : none
// DESCRIPTION : NXTway-GS balance control init function. This function
//               initializes internal state variables. To use this function,
//               left & right wheel motors count also need to be 0 reset.
// SAMPLE CODE :
//		nxt_motor_set_speed(NXT_PORT_C, 0, 1); /* stop left wheel motor  */
//		nxt_motor_set_speed(NXT_PORT_B, 0, 1); /* stop right wheel motor */
//		balance_init();						   /* init NXTway-GS balance control */
//      /* motor must be stopped before motor counter is 0 reset */
//		nxt_motor_set_count(NXT_PORT_C, 0);    /* left motor count 0 reset  */
//		nxt_motor_set_count(NXT_PORT_B, 0);    /* right motor count 0 reset */
//*****************************************************************************

//*****************************************************************************
// ֐  : balance_control
//     :
//   (F32)args_cmd_forward : Oi/i߁B100(Oiől)`-100(iől)
//   (F32)args_cmd_turn    : 񖽗߁B100(Eől)`-100(ől)
//   (F32)args_gyro        : WCZTl
//   (F32)args_gyro_offset : WCZTItZbgl
//   (F32)args_theta_m_l   : [^GR[_l
//   (F32)args_theta_m_r   : E[^GR[_l
//   (F32)args_battery     : obedl(mV)
// ߂l  :
//   (S8*)ret_pwm_l        : [^PWMo͒l
//   (S8*)ret_pwm_r        : E[^PWMo͒l
// Tv    :  NXTway-GSoX֐B
//            ̊֐4msecŋN邱ƂOɐ݌vĂ܂B
//            ȂAWCZTItZbgl̓ZT̂ђʓdɂhtg
//            𔺂܂̂ŁAKX␳Kv܂B܂AE̎ԗ֋쓮
//            [^͌̍ɂAPWMo͂^Ă]قȂꍇ
//            ܂B̏ꍇ͕ʓr␳@\ǉKv܂B
// gp  :
//        /* ōi */
//        balance_control(
//          (F32)100,                                  /* Oiō */
//          (F32)0,                                    /* 񖽗 */
//          (F32)ecrobot_get_gyro_sensor(NXT_PORT_S4), /* WCZTl */
//          (F32)605,                                  /* ԑ̒~̃WCZTl */
//          (F32)nxt_motor_get_count(NXT_PORT_C),      /* [^GR[_l */
//          (F32)nxt_motor_get_count(NXT_PORT_B),      /* E[^GR[_l */
//          (F32)ecrobot_get_battery_voltage(),        /* obedl(mV) */
//          &pwm_l,                                    /* [^PWMo͒l */
//          &pwm_r);                                   /* E[^PWMo͒l */
//*****************************************************************************
//*****************************************************************************
// ֐  : balance_init
//     : 
// ߂l  : 
// Tv    : NXTway-GSoX䏉֐Bԗʕϐ܂B
//           ̊֐ɂoX@\ꍇ́AčE
//           ԗ֋쓮[^[̃GR[_l0ɃZbgĂB
// gp  :
//		nxt_motor_set_speed(NXT_PORT_C, 0, 1); /* [^~ */
//		nxt_motor_set_speed(NXT_PORT_B, 0, 1); /* E[^~ */
//		balance_init();						   /* NXTway-GSoX䏉 */
//      /* [^GR[_l0ZbgOɃ[^~Ă邱 */
//		nxt_motor_set_count(NXT_PORT_C, 0);    /* [^GR[_0Zbg */
//		nxt_motor_set_count(NXT_PORT_B, 0);    /* E[^GR[_0Zbg */
//*****************************************************************************

/* Model step function */
void balance_control(F32 args_cmd_forward, F32 args_cmd_turn, F32
                     args_gyro, F32 args_gyro_offset, F32
                     args_theta_m_l, F32 args_theta_m_r, F32
                     args_battery, S8 *ret_pwm_l, S8 *ret_pwm_r)
{
  {
    F32 tmp_theta;
    F32 tmp_theta_lpf;
    F32 tmp_pwm_r_limiter;
    F32 tmp_psidot;
    F32 tmp_pwm_turn;
    F32 tmp_pwm_l_limiter;
    F32 tmp_thetadot_cmd_lpf;
    F32 tmp[4];
    F32 tmp_theta_0[4];
    S32 tmp_0;

    /* Sum: '<S8>/Sum' incorporates:
     *  Constant: '<S3>/Constant6'
     *  Constant: '<S8>/Constant'
     *  Constant: '<S8>/Constant1'
     *  Gain: '<S3>/Gain1'
     *  Gain: '<S8>/Gain2'
     *  Inport: '<Root>/cmd_forward'
     *  Product: '<S3>/Divide'
     *  Product: '<S8>/Product'
     *  Sum: '<S8>/Sum1'
     *  UnitDelay: '<S8>/Unit Delay'
     */
    tmp_thetadot_cmd_lpf = (((args_cmd_forward / CMD_MAX) * K_THETADOT) * (1.0F
      - A_R)) + (A_R * ud_thetadot_cmd_lpf);

    /* Gain: '<S4>/Gain' incorporates:
     *  Gain: '<S4>/deg2rad'
     *  Gain: '<S4>/deg2rad1'
     *  Inport: '<Root>/theta_m_l'
     *  Inport: '<Root>/theta_m_r'
     *  Sum: '<S4>/Sum1'
     *  Sum: '<S4>/Sum4'
     *  Sum: '<S4>/Sum6'
     *  UnitDelay: '<S10>/Unit Delay'
     */
    tmp_theta = (((DEG2RAD * args_theta_m_l) + ud_psi) + ((DEG2RAD *
      args_theta_m_r) + ud_psi)) * 0.5F;

    /* Sum: '<S11>/Sum' incorporates:
     *  Constant: '<S11>/Constant'
     *  Constant: '<S11>/Constant1'
     *  Gain: '<S11>/Gain2'
     *  Product: '<S11>/Product'
     *  Sum: '<S11>/Sum1'
     *  UnitDelay: '<S11>/Unit Delay'
     */
    tmp_theta_lpf = ((1.0F - A_D) * tmp_theta) + (A_D * ud_theta_lpf);

    /* Gain: '<S4>/deg2rad2' incorporates:
     *  Inport: '<Root>/gyro'
     *  Inport: '<Root>/gyro_offset'
     *  Sum: '<S4>/Sum2'
     */
    tmp_psidot = (args_gyro - args_gyro_offset) * DEG2RAD;

    /* Gain: '<S2>/Gain' incorporates:
     *  Constant: '<S3>/Constant2'
     *  Constant: '<S3>/Constant3'
     *  Constant: '<S6>/Constant'
     *  Constant: '<S9>/Constant'
     *  Gain: '<S1>/FeedbackGain'
     *  Gain: '<S1>/IntegralGain'
     *  Gain: '<S6>/Gain3'
     *  Inport: '<Root>/battery'
     *  Product: '<S2>/Product'
     *  Product: '<S9>/Product'
     *  Sum: '<S1>/Sum2'
     *  Sum: '<S1>/sum_err'
     *  Sum: '<S6>/Sum2'
     *  Sum: '<S9>/Sum'
     *  UnitDelay: '<S10>/Unit Delay'
     *  UnitDelay: '<S11>/Unit Delay'
     *  UnitDelay: '<S5>/Unit Delay'
     *  UnitDelay: '<S7>/Unit Delay'
     */
    tmp[0] = ud_theta_ref;
    tmp[1] = 0.0F;
    tmp[2] = tmp_thetadot_cmd_lpf;
    tmp[3] = 0.0F;
    tmp_theta_0[0] = tmp_theta;
    tmp_theta_0[1] = ud_psi;
    tmp_theta_0[2] = (tmp_theta_lpf - ud_theta_lpf) / EXEC_PERIOD;
    tmp_theta_0[3] = tmp_psidot;
    tmp_pwm_r_limiter = 0.0F;
    for (tmp_0 = 0; tmp_0 < 4; tmp_0++) {
      tmp_pwm_r_limiter += (tmp[tmp_0] - tmp_theta_0[tmp_0]) * K_F[(tmp_0)];
    }

    tmp_pwm_r_limiter = (((K_I * ud_err_theta) + tmp_pwm_r_limiter) /
                         ((BATTERY_GAIN * args_battery) - BATTERY_OFFSET)) *
      100.0F;

    /* Gain: '<S3>/Gain2' incorporates:
     *  Constant: '<S3>/Constant1'
     *  Inport: '<Root>/cmd_turn'
     *  Product: '<S3>/Divide1'
     */
    tmp_pwm_turn = (args_cmd_turn / CMD_MAX) * K_PHIDOT;

    /* Sum: '<S2>/Sum' */
    tmp_pwm_l_limiter = tmp_pwm_r_limiter + tmp_pwm_turn;

    /* Saturate: '<S2>/pwm_l_limiter' */
    tmp_pwm_l_limiter = rt_SATURATE(tmp_pwm_l_limiter, -100.0F, 100.0F);

    /* Outport: '<Root>/pwm_l' incorporates:
     *  DataTypeConversion: '<S1>/Data Type Conversion'
     */
    (*ret_pwm_l) = (S8)tmp_pwm_l_limiter;

    /* Sum: '<S2>/Sum1' */
    tmp_pwm_r_limiter -= tmp_pwm_turn;

    /* Saturate: '<S2>/pwm_r_limiter' */
    tmp_pwm_r_limiter = rt_SATURATE(tmp_pwm_r_limiter, -100.0F, 100.0F);

    /* Outport: '<Root>/pwm_r' incorporates:
     *  DataTypeConversion: '<S1>/Data Type Conversion6'
     */
    (*ret_pwm_r) = (S8)tmp_pwm_r_limiter;

    /* Sum: '<S7>/Sum' incorporates:
     *  Gain: '<S7>/Gain'
     *  UnitDelay: '<S7>/Unit Delay'
     */
    tmp_pwm_l_limiter = (EXEC_PERIOD * tmp_thetadot_cmd_lpf) + ud_theta_ref;

    /* Sum: '<S10>/Sum' incorporates:
     *  Gain: '<S10>/Gain'
     *  UnitDelay: '<S10>/Unit Delay'
     */
    tmp_pwm_turn = (EXEC_PERIOD * tmp_psidot) + ud_psi;

    /* Sum: '<S5>/Sum' incorporates:
     *  Gain: '<S5>/Gain'
     *  Sum: '<S1>/Sum1'
     *  UnitDelay: '<S5>/Unit Delay'
     *  UnitDelay: '<S7>/Unit Delay'
     */
    tmp_pwm_r_limiter = ((ud_theta_ref - tmp_theta) * EXEC_PERIOD) +
      ud_err_theta;

    /* user code (Update function Body) */
    /* System '<Root>' */
    /* 񉉎Zpԗʕۑ */

    /* Update for UnitDelay: '<S5>/Unit Delay' */
    ud_err_theta = tmp_pwm_r_limiter;

    /* Update for UnitDelay: '<S7>/Unit Delay' */
    ud_theta_ref = tmp_pwm_l_limiter;

    /* Update for UnitDelay: '<S8>/Unit Delay' */
    ud_thetadot_cmd_lpf = tmp_thetadot_cmd_lpf;

    /* Update for UnitDelay: '<S10>/Unit Delay' */
    ud_psi = tmp_pwm_turn;

    /* Update for UnitDelay: '<S11>/Unit Delay' */
    ud_theta_lpf = tmp_theta_lpf;
  }
}

/* Model initialize function */
void balance_init(void)
{
  /* Registration code */

  /* states (dwork) */

  /* custom states */
  ud_err_theta = 0.0F;
  ud_theta_ref = 0.0F;
  ud_thetadot_cmd_lpf = 0.0F;
  ud_psi = 0.0F;
  ud_theta_lpf = 0.0F;
}

/*======================== TOOL VERSION INFORMATION ==========================*
 * MATLAB 7.7 (R2008b)30-Jun-2008                                             *
 * Simulink 7.2 (R2008b)30-Jun-2008                                           *
 * Real-Time Workshop 7.2 (R2008b)30-Jun-2008                                 *
 * Real-Time Workshop Embedded Coder 5.2 (R2008b)30-Jun-2008                  *
 * Stateflow 7.2 (R2008b)30-Jun-2008                                          *
 * Stateflow Coder 7.2 (R2008b)30-Jun-2008                                    *
 * Simulink Fixed Point 6.0 (R2008b)30-Jun-2008                               *
 *============================================================================*/

/*======================= LICENSE IN USE INFORMATION =========================*
 * matlab                                                                     *
 * real-time_workshop                                                         *
 * rtw_embedded_coder                                                         *
 * simulink                                                                   *
 *============================================================================*/
/******************************** END OF FILE ********************************/
