/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004-2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	A[@\
 */

#ifndef _ALARM_H_
#define _ALARM_H_

/*
 *  A[ID̓Ȓl̒`
 */
#define ALMID_NULL		((AlarmType) UINT8_INVALID)	/* ID */

/*
 *  JE^EA[ێϐ̐錾
 */
extern const UINT8		tnum_counter;		/* JE^̐ */
extern const UINT8		tnum_alarm;			/* A[̐ */

/*
 *  JE^ubN
 */
extern const TickType	cntinib_maxval[];	/* JE^̍ől */
extern const TickType	cntinib_maxval2[];	/* JE^̍ől2{+1 */
extern const TickType	cntinib_tickbase[];	/* 1ŐiރeBbN */
extern const TickType	cntinib_mincyc[];	/* ̍ŏl */

/*
 *  JE^ǗubN
 */
extern TickType			cntcb_curval[];		/* JE^̌݃eBbN */
extern AlarmType		cntcb_almque[];		/* A[̃L[ */

/*
 *  A[ubN
 */
extern const CounterType alminib_cntid[];	/* tĂJE^ */
extern const FP			 alminib_cback[];	/* A[R[obN */
extern const AppModeType alminib_autosta[];	/* N郂[h */
extern const TickType	 alminib_almval[];	/* expire eBbNl */
extern const TickType	 alminib_cycle[];	/* A[̎ */

/*
 *  A[ǗubN
 *
 *  A[A[L[ɑ}ĂȂꍇCalmcb_nextɂ
 *  ̃A[IDĂinextwĂjD
 */
extern AlarmType		almcb_next[];		/* A[L[ */
extern AlarmType		almcb_prev[];		/* A[L[ */
extern TickType			almcb_almval[];		/* expire eBbNl */
extern TickType			almcb_cycle[];		/* A[̎ */

/*
 *  A[@\̏
 */
extern void	alarm_initialize(void);

#endif /* _ALARM_H_ */
